/*
 * Decompiled with CFR 0.152.
 */
package com.dinzeer.srelic.Utils;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DashMessage {
    private final double dy;
    private final double dashDistance;

    public DashMessage(double dy, double dashDistance) {
        this.dy = dy;
        this.dashDistance = dashDistance;
    }

    public static void encode(DashMessage msg, FriendlyByteBuf buffer) {
        buffer.writeDouble(msg.dy);
        buffer.writeDouble(msg.dashDistance);
    }

    public static DashMessage decode(FriendlyByteBuf buffer) {
        return new DashMessage(buffer.readDouble(), buffer.readDouble());
    }

    public static void handle(DashMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LocalPlayer entity;
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT && (entity = Minecraft.m_91087_().f_91074_) != null) {
                DashMessage.vmove((LivingEntity)entity, msg.dy, msg.dashDistance);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void vmove(LivingEntity livingEntity, double dy, double dashDistance) {
        float yaw = livingEntity.m_146908_();
        double dx = -Math.sin(Math.toRadians(yaw)) * dashDistance;
        double dz = Math.cos(Math.toRadians(yaw)) * dashDistance;
        livingEntity.m_20256_(new Vec3(dx, dy, dz));
    }
}

